unit Query1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Config1C;

type
  TQuery1C = class(TComponent1C)
  private
    FObj: Variant;
    FSQL: TStrings;
    //   1-
    function CreateObj: Variant;
    // get-  set-
    function GetAttributesValue(const AAttributeName: String): Variant;
    procedure SetQuery(const AValue: TStrings);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    // 
    destructor Destroy; override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "Query.Obj."
    //   "Query['']"
    property Attributes[const AttributeName: String]: Variant
      read GetAttributesValue; default;
    //   1-
    // (<>)
    function Execute(AQueryText: String = ''): Boolean;
    // (<>,<>)
    function Group(AGroup: Variant; ADirection: Integer = 1): Boolean;
    // (<>)
    function IsItAGroup(AGroupName: String): Boolean;
    // ()
    function BeginOfPeriod: Variant;
    // ()
    function EndOfPeriod: Variant;
    // ()
    function ToSelectionBegin: Boolean;
    // (<>)
    function UseSelectionColumn(AColumnName: String): String;
    // (<>,<>,<>)
    function Unload(ATable: Variant; ARegime: Variant;
      ATotal: Variant): Boolean;
    // (<>,<>)
    function OrderValue(AGroup: Variant; AOrder: Variant): Variant;
    // (<>)
    function GetAttribute(AAttributeName: String): Variant;
  published
    //  
    property SQL: TStrings read FSQL write SetQuery;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TQuery1C]);
end;

{ TQuery1C }

// ()
function TQuery1C.BeginOfPeriod: Variant;
begin
  Result := FObj.(Unassigned);
end;

//    - 
//   /  OLE-
//      !
procedure TQuery1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// 
constructor TQuery1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
  FSQL := TStringList.Create;
end;

//   1-
function TQuery1C.CreateObj: Variant;
begin
  try
    Result := Configuration.CreateObject('');
  except
    MessageDlg('    ""!',
      mtError, [mbOK], 0);
  end;
end;

// 
destructor TQuery1C.Destroy;
begin
  FSQL.Free;
  inherited;
end;

// ()
function TQuery1C.EndOfPeriod: Variant;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
function TQuery1C.Execute(AQueryText: String): Boolean;
begin
  if AQueryText <> '' then
    Result := Boolean(FObj.(OleVariant(AQueryText)))
  else if StrPas(SQL.GetText) <> '' then
    Result := Boolean(FObj.(OleVariant(StrPas(SQL.GetText))))
  else
    Result := False;
end;

// (<>)
function TQuery1C.GetAttribute(AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

function TQuery1C.GetAttributesValue(const AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

// (<>,<>)
function TQuery1C.Group(AGroup: Variant; ADirection: Integer): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AGroup),
    OleVariant(ADirection)));
end;

// (<>)
function TQuery1C.IsItAGroup(AGroupName: String): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AGroupName)));
end;

// (<>,<>)
function TQuery1C.OrderValue(AGroup, AOrder: Variant): Variant;
begin
  Result := FObj.(OleVariant(AGroup),
    OleVariant(AOrder));
end;

procedure TQuery1C.SetQuery(const AValue: TStrings);
begin
  if FSQL.Text <> AValue.Text then begin
    FSQL.BeginUpdate;
    try
      FSQL.Assign(AValue);
    finally
      FSQL.EndUpdate;
    end;
  end;
end;

// ()
function TQuery1C.ToSelectionBegin: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>,<>,<>)
function TQuery1C.Unload(ATable, ARegime, ATotal: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ATable),
    OleVariant(ARegime), OleVariant(ATotal)));
end;

// (<>)
function TQuery1C.UseSelectionColumn(AColumnName: String): String;
begin
  Result := FObj.(OleVariant(AColumnName));
end;

end.
