unit Regis1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  config1C;

type
  TRegister1C = class(TComponent1C)
  private
    FObj: Variant;
    FObjName: String;
    //   1-
    function CreateObj: Variant;
    // get-  set-
    procedure SetObjName(const AValue: String);
    function GetAttributesValue(const AAttributeName: String): Variant;
    procedure SetAttributesValue(const AAttributeName: String;
      const AValue: Variant);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "Register.Obj."
    //   "Register['']"
    property Attributes[const AttributeName: String]: Variant
      read GetAttributesValue write SetAttributesValue; default;
    //   1-
    // ()
    function Kind: String;
    // ()
    function UserKind: String;
    // (<>,<>,<>,<>)
    procedure SetType(AAttributeName, ATypeName: String;
      ALength, APrecision: Variant);
    // (<>,<>)
    procedure SetAttribute(AAttributeName: String; AValue: Variant);
    // (<>)
    function GetAttribute(AAttributeName: String): Variant;
    // (<>,<>,<>)
    procedure SelectActs(ADate1: Variant; ADate2: Variant;
      ASelectionName: String = '*');
    // (<>)
    function SelectDocActs(ADocument: Variant): Boolean;
    // (<>)
    function BackwardOrder(ARegime: Variant): Boolean;
    // ()
    function GetDocAct: Boolean;
    // ()
    function CurrentDocument: Variant;
    // ()
    function LineNum: Integer;
    // ()
    procedure SelectTotals;
    // ()
    function GetTotal: Boolean;
    // (<>)
    function TempCalc(ARegime: Variant): Boolean;
    // (<>,<>,<>)
    procedure UnloadTotals(ATable, AFilter, AClear: Variant);
    // (<>,<>,<>)
    procedure SetFilterValue(AAttributeName: String;
      AValue: Variant; ARegime: Variant);
    //   
    // (<>)
    // (<>)
    procedure UsePeriod(AParam1: Variant); overload;
    // (<>,<>,<>)
    // (<>,<>,<>)
    procedure UsePeriod(AParam1, AParam2, AParam3: Variant); overload;
    // (<>,<>)
    // (<>,<>)
    // (<>,<>)
    procedure UsePeriod(AParam1, AParam2: Variant); overload;
    // ()
    procedure TotalsGet;
    //   
    // ()
    procedure GetRests;
    // (<>,<>)
    procedure SelectActsWithRests(ADate: Variant;
      ASelectionName: String = '*');
    // (<>,<>)
    procedure CalcRegsOnBeg(ADate: Variant;
      ASelectionName: String = '*');
    // (<>,<>)
    procedure CalcRegsOnEnd(ADate: Variant;
      ASelectionName: String = '*');
  published
    //   (     )
    property ObjName: String read FObjName write SetObjName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TRegister1C]);
end;

{ TRegister1C }

// (<>)
function TRegister1C.BackwardOrder(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// (<>,<>)
procedure TRegister1C.CalcRegsOnBeg(ADate: Variant;
  ASelectionName: String);
begin
  FObj.(OleVariant(ADate),
    OleVariant(ASelectionName));
end;

// (<>,<>)
procedure TRegister1C.CalcRegsOnEnd(ADate: Variant;
  ASelectionName: String);
begin
  FObj.(OleVariant(ADate),
    OleVariant(ASelectionName));
end;

//    - 
//   /  OLE-
//      !
procedure TRegister1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// 
constructor TRegister1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
  FObjName := '';
end;

//   1-
function TRegister1C.CreateObj: Variant;
var
  FullObjName: String;
begin
  try
    FullObjName := '.' + ObjName;
    Result := Configuration.CreateObject(FullObjName);
  except
    Result := Unassigned;
    MessageDlg('    "' + FullObjName + '"!',
      mtError, [mbOK], 0);
  end;
end;

// ()
function TRegister1C.CurrentDocument: Variant;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
function TRegister1C.GetAttribute(AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

function TRegister1C.GetAttributesValue(const AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

// ()
function TRegister1C.GetDocAct: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
procedure TRegister1C.GetRests;
begin
  FObj.(Unassigned);
end;

// ()
function TRegister1C.GetTotal: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TRegister1C.Kind: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TRegister1C.LineNum: Integer;
begin
  Result := FObj.(Unassigned);
end;

// (<>,<>,<>)
procedure TRegister1C.SelectActs(ADate1, ADate2: Variant;
  ASelectionName: String);
begin
  FObj.(OleVariant(ADate1), OleVariant(ADate2),
    OleVariant(ASelectionName));
end;

// (<>,<>)
procedure TRegister1C.SelectActsWithRests(ADate: Variant;
  ASelectionName: String);
begin
  FObj.(OleVariant(ADate),
    OleVariant(ASelectionName));
end;

// (<>)
function TRegister1C.SelectDocActs(ADocument: Variant): Boolean;
begin
  Result := Boolean(FObj.(
    OleVariant(ADocument)));
end;

// ()
procedure TRegister1C.SelectTotals;
begin
  FObj.(Unassigned);
end;

// (<>,<>)
procedure TRegister1C.SetAttribute(AAttributeName: String;
  AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

procedure TRegister1C.SetAttributesValue(const AAttributeName: String;
  const AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

// (<>,<>,<>)
procedure TRegister1C.SetFilterValue(AAttributeName: String; AValue,
  ARegime: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue), OleVariant(ARegime));
end;

procedure TRegister1C.SetObjName(const AValue: String);
begin
  if FObjName <> AValue then begin
    FObjName := AValue;
    //     
    if Assigned(Configuration) and Configuration.Connected then
      //   
      FObj := CreateObj
    else
      //  - 
      FObj := Unassigned;
  end;
end;

// (<>,<>,<>,<>)
procedure TRegister1C.SetType(AAttributeName, ATypeName: String; ALength,
  APrecision: Variant);
begin
  FObj.(OleVariant(AAttributeName), OleVariant(ATypeName),
    OleVariant(ALength), OleVariant(APrecision));
end;

// (<>)
function TRegister1C.TempCalc(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// ()
procedure TRegister1C.TotalsGet;
begin
  FObj.(Unassigned);
end;

// (<>,<>,<>)
procedure TRegister1C.UnloadTotals(ATable, AFilter, AClear: Variant);
begin
  FObj.(OleVariant(ATable), OleVariant(AFilter),
    OleVariant(AClear));
end;

// (<>)
// (<>)
procedure TRegister1C.UsePeriod(AParam1: Variant);
begin
  FObj.(OleVariant(AParam1));
end;

// (<>,<>,<>)
// (<>,<>,<>)
procedure TRegister1C.UsePeriod(AParam1, AParam2, AParam3: Variant);
begin
  FObj.(OleVariant(AParam1), OleVariant(AParam2),
    OleVariant(AParam3));
end;

// (<>,<>)
// (<>,<>)
// (<>,<>)
procedure TRegister1C.UsePeriod(AParam1, AParam2: Variant);
begin
  FObj.(OleVariant(AParam1), OleVariant(AParam2));
end;

// ()
function TRegister1C.UserKind: String;
begin
  Result := FObj.(Unassigned);
end;

end.
