unit VList1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  config1C;

type
  TValueList1C = class(TComponent1C)
  private
    FObj: Variant;
    //   1-
    function CreateObj: Variant;
    // get-  set-
    function GetValuesValue(const AValueName: String): Variant;
    procedure SetValuesValue(const AValueName: String;
      const AValue: Variant);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "ValueList.Obj."
    //   "ValueList['']"
    property Values[const ValueName: String]: Variant
      read GetValuesValue write SetValuesValue; default;
    //   1-
    // (<>,<>)
    procedure AddValue(AValue: Variant; APresent: String);
    // (<>,<>,<>,<>)
    procedure InsertValue(APosition: Integer; AValue: Variant;
      APresent: String; ACount: Integer = 1);
    // ()
    function GetListSize: Integer;
    // (<>,<>,<>,<>)
    procedure SetValue(APosition: Integer; AValue: Variant;
      APresent: String; ACount: Integer = 1);
    // (<>,<>)
    procedure SetByPresent(APresent: String; AValue: Variant);
    // (<>,<>)
    procedure Sort(ADirection: Integer = 0; ADocByDate: Integer = 0);
    // (<>)
    procedure SortByPresent(ADirection: Integer = 0);
    // (<>)
    function BelongsToList(AValue: Variant): Boolean;
    // (<>)
    function FindValue(AValue: Variant): Integer;
    // (<>,<>)
    function GetValue(APosition: Integer): Variant;
    // (<>)
    function GetByPresent(APresent: String): Variant;
    // (<>)
    procedure LoadFromString(ASource: String);
    // ()
    function SaveToString: String;
    // (<>,<>)
    function Mark(APosition: Integer; AMark: Variant): Boolean;
    // (<>,<>)
    procedure RemoveValue(APosition: Integer; ACount: Integer = 1);
    // ()
    procedure RemoveAll;
    // (<>,<>)
    procedure MoveValue(ACount: Integer; APosition: Integer);
    // (<>,<>,<>)
    procedure Unload(ADest: Variant; AStartPosition: Integer = 1;
      ACount: Integer = -1);
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TValueList1C]);
end;

{ TValueList1C }

// (<>,<>)
procedure TValueList1C.AddValue(AValue: Variant; APresent: String);
begin
  FObj.(OleVariant(AValue), OleVariant(APresent));
end;

// (<>)
function TValueList1C.BelongsToList(AValue: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AValue)));
end;

//    - 
//   /  OLE-
//      !
procedure TValueList1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// 
constructor TValueList1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
end;

//   1-
function TValueList1C.CreateObj: Variant;
begin
  try
    Result := Configuration.CreateObject('');
  except
    MessageDlg('    " "!',
      mtError, [mbOK], 0);
  end;
end;

// (<>)
function TValueList1C.FindValue(AValue: Variant): Integer;
begin
  Result := FObj.(OleVariant(AValue));
end;

// (<>)
function TValueList1C.GetByPresent(APresent: String): Variant;
begin
  Result := FObj.(OleVariant(APresent));
end;

// ()
function TValueList1C.GetListSize: Integer;
begin
  Result := FObj.(Unassigned);
end;

// (<>,<>)
function TValueList1C.GetValue(APosition: Integer): Variant;
begin
  Result := FObj.(OleVariant(APosition));
end;

function TValueList1C.GetValuesValue(const AValueName: String): Variant;
begin
  Result := FObj.(OleVariant(AValueName));
end;

// (<>,<>,<>,<>)
procedure TValueList1C.InsertValue(APosition: Integer; AValue: Variant;
  APresent: String; ACount: Integer);
begin
  FObj.(OleVariant(APosition), OleVariant(AValue),
    OleVariant(APresent), OleVariant(ACount));
end;

// (<>)
procedure TValueList1C.LoadFromString(ASource: String);
begin
  FObj.(OleVariant(ASource));
end;

// (<>,<>)
function TValueList1C.Mark(APosition: Integer; AMark: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(APosition),
    OleVariant(AMark)));
end;

// (<>,<>)
procedure TValueList1C.MoveValue(ACount, APosition: Integer);
begin
  FObj.(OleVariant(ACount), OleVariant(APosition));
end;

// ()
procedure TValueList1C.RemoveAll;
begin
  FObj.(Unassigned);
end;

// (<>,<>)
procedure TValueList1C.RemoveValue(APosition, ACount: Integer);
begin
  FObj.(OleVariant(APosition), OleVariant(ACount));
end;

// ()
function TValueList1C.SaveToString: String;
begin
  Result := FObj.(Unassigned);
end;

// (<>,<>)
procedure TValueList1C.SetByPresent(APresent: String; AValue: Variant);
begin
  FObj.(OleVariant(APresent), OleVariant(AValue));
end;

// (<>,<>,<>,<>)
procedure TValueList1C.SetValue(APosition: Integer; AValue: Variant;
  APresent: String; ACount: Integer);
begin
  FObj.(OleVariant(APosition), OleVariant(AValue),
    OleVariant(APresent), OleVariant(ACount));
end;

procedure TValueList1C.SetValuesValue(const AValueName: String;
  const AValue: Variant);
begin
  FObj.(OleVariant(AValueName), OleVariant(AValue));
end;

// (<>,<>)
procedure TValueList1C.Sort(ADirection, ADocByDate: Integer);
begin
  FObj.(OleVariant(ADirection), OleVariant(ADocByDate));
end;

// (<>)
procedure TValueList1C.SortByPresent(ADirection: Integer);
begin
  FObj.(OleVariant(ADirection));
end;

// (<>,<>,<>)
procedure TValueList1C.Unload(ADest: Variant; AStartPosition,
  ACount: Integer);
begin
  if ACount < 0 then ACount := FObj.(Unassigned);
  FObj.(OleVariant(ADest), OleVariant(AStartPosition),
    OleVariant(ACount));
end;

end.
